classdef enum_model_type < Simulink.IntEnumType
    enumeration
        GEM(0)
        ALPHA(1)
        REVS(2)
    end
    
    methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
    
end
